%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%----------BAR-Paired Sample with Variance Reduction Trick-----------------

function[probability_of_choosing_treatment_1] = f_PS_with_VR(treatment_1, treatment_2, ...
    lower_interval, upper_interval, accuracy);

%Making the pairs
n_1 = numel(treatment_1);
n_2 = numel(treatment_2);
montecarlo_pairs = 10^(accuracy/2);
pair = 0;

while pair < montecarlo_pairs;
pair = pair + 1;
mod_treatment_1 = treatment_1;
if n_1 == n_2;
elseif n_1 > n_2;
    difference = n_1 - n_2;
    which_ones_to_drop = randsample(n_1,difference);
    mod_treatment_1(which_ones_to_drop,:) = [];
end;

data = [mod_treatment_1 treatment_2];

%Making the pairs
montecarlo_pairs = 10^(accuracy/2);
truncated_data = data;
n = numel(truncated_data(:,1));
if floor(n/2) < ceil(n/2);
    uneven_sample = randsample(n,1);
    truncated_data(uneven_sample,:) = [];end;
which_ones_to_pair = randsample(floor(n/2)+floor(n/2),floor(n/2));
mod_treatment_1 = truncated_data(which_ones_to_pair,1);
truncated_data(which_ones_to_pair,:) = [];
mod_treatment_2 = truncated_data(:,2);
n = floor(n/2);

%Normalizing the value of the treatment samples
normalized_treatment_1 = (mod_treatment_1 - lower_interval) / (upper_interval - lower_interval);
normalized_treatment_2 = (mod_treatment_2 - lower_interval) / (upper_interval - lower_interval);
x = normalized_treatment_1;

%Montecarlo
montecarlo_shots = 10^(accuracy/2);
shot = 0;
result = 0;
while shot < montecarlo_shots;
shot = shot + 1;

x_reloaded = x;
y_reloaded = normalized_treatment_2;

%Making the random pairs
for i=1:1:n;
  which_ones_to_pair = randsample(n-i+1,2,true);
  paired_sample(i,1) = x_reloaded(which_ones_to_pair(1,1),1) - y_reloaded(which_ones_to_pair(2,1),1);
  x_reloaded(which_ones_to_pair(1,1),:) = [];
  y_reloaded(which_ones_to_pair(2,1),:) = [];
end;

%Assigning values to the pairs
for i=1:1:n;
  flipping_coin = rand(1);
  if paired_sample(i,1)>0 & paired_sample(i,1)>flipping_coin;
     paired_sample_result_x(i,1) = 1;
     paired_sample_result_y(i,1) = 0;
  elseif paired_sample(i,1)<0 & -paired_sample(i,1)>flipping_coin;
     paired_sample_result_x(i,1) = 0;
     paired_sample_result_y(i,1) = 1;
  else;
     paired_sample_result_x(i,1) = 0;
     paired_sample_result_y(i,1) = 0;
  end;
end;

%Chosing the better treatment
if sum(paired_sample_result_x) > sum(paired_sample_result_y);
    result = result + (1 / montecarlo_shots);
elseif sum(paired_sample_result_x) < sum(paired_sample_result_y);
else;
    result = result + (.5 / montecarlo_shots);
end;

end; %Ending the 'choose better treatment' loop
probability_of_choosing_treatment_1_on_this_pair(pair,1) = result;
end; %Ending the 'Making pairs' loop
probability_of_choosing_treatment_1 = sum(probability_of_choosing_treatment_1_on_this_pair) / montecarlo_pairs;